<?php
$title = $title ?? 'Kategori Produk';
require __DIR__ . '/../../layouts/header.php';
?>

<div class="card">
  <div style="display:flex; justify-content:space-between; align-items:center; gap:10px;">
    <div>
      <h2 style="margin:0;"><?= htmlspecialchars($title) ?></h2>
      <div style="color:var(--muted); font-size:13px; margin-top:4px;">
        Master kategori untuk produk/jasa
      </div>
    </div>
    <div>
      <a class="btn" href="/master/kategori-produk/create">+ Tambah</a>
    </div>
  </div>

  <div style="margin-top:14px; overflow:auto;">
    <table class="table" style="min-width:800px;">
      <thead>
        <tr>
          <th>Nama</th>
          <th>Status</th>
          <th>Urutan</th>
          <th style="width:180px;">Aksi</th>
        </tr>
      </thead>
      <tbody>
        <?php if (!empty($rows)): foreach ($rows as $r): ?>
          <tr>
            <td><?= htmlspecialchars($r['name']) ?></td>
            <td><?= ((int)$r['is_active']===1) ? 'Aktif' : 'Nonaktif' ?></td>
            <td><?= (int)$r['sort_order'] ?></td>
            <td>
              <a class="btn" href="/master/kategori-produk/edit/<?= (int)$r['id'] ?>">Edit</a>
              <a class="btn" href="/master/kategori-produk/toggle/<?= (int)$r['id'] ?>"
                 onclick="return confirm('Ubah status kategori ini?')">
                <?= ((int)$r['is_active']===1) ? 'Nonaktifkan' : 'Aktifkan' ?>
              </a>
            </td>
          </tr>
        <?php endforeach; else: ?>
          <tr><td colspan="4" style="text-align:center;color:var(--muted);">Belum ada kategori</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require __DIR__ . '/../../layouts/footer.php'; ?>
