<?php
$title = $title ?? 'Tambah Kategori Produk';
require __DIR__ . '/../../layouts/header.php';
?>

<div class="card">
  <div style="display:flex; justify-content:space-between; align-items:center; gap:10px;">
    <div>
      <h2 style="margin:0;"><?= htmlspecialchars($title) ?></h2>
      <div style="color:var(--muted); font-size:13px; margin-top:4px;">
        Tambahkan kategori baru untuk pengelompokan produk
      </div>
    </div>
  </div>

  <?php if (!empty($error)): ?>
    <div class="alert alert-danger" style="margin-top:12px;">
      <?= htmlspecialchars($error) ?>
    </div>
  <?php endif; ?>

  <form method="post" action="/master/kategori-produk/store" style="margin-top:14px;">
    <div class="form">
      <label>Nama Kategori <span style="color:red;">*</span></label>
      <input type="text" name="name" required autofocus>

      <label>Urutan</label>
      <input type="number" name="sort_order" value="0">

      <label>Status</label>
      <select name="is_active">
        <option value="1">Aktif</option>
        <option value="0">Nonaktif</option>
      </select>

      <label>Catatan (opsional)</label>
      <textarea name="notes" rows="3"></textarea>

      <div style="margin-top:16px; display:flex; gap:8px;">
        <button class="btn" type="submit">Simpan</button>
        <a class="btn btn-light" href="/master/kategori-produk">Batal</a>
      </div>
    </div>
  </form>
</div>

<?php require __DIR__ . '/../../layouts/footer.php'; ?>
