<?php

class Request
{
  public static function method(): string
  {
    return strtoupper($_SERVER['REQUEST_METHOD'] ?? 'GET');
  }

  public static function path(): string
  {
    $uri = $_SERVER['REQUEST_URI'] ?? '/';
    $path = parse_url($uri, PHP_URL_PATH) ?: '/';
    // normalisasi trailing slash (kecuali root)
    if ($path !== '/' && str_ends_with($path, '/')) {
      $path = rtrim($path, '/');
    }
    return $path;
  }

  public static function input(string $key, mixed $default = null): mixed
  {
    return $_POST[$key] ?? $_GET[$key] ?? $default;
  }

  public static function post(string $key, mixed $default = null): mixed
  {
    return $_POST[$key] ?? $default;
  }
}
